C
C------------------------------------------------------
C
C     Problem:    PDAE4
C
C     Date:       16.12.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a, b, u, v, u_x, v_x, u_xx, v_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION FLUX
C      FLUX = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t
      u_t = -a*v_xx
C
*     FUNCTION alg_equ
      alg_equ = v - u_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = b*sin(pi*x)
C
*     FUNCTION v_0
      v_0 = -pi**2*b*sin(pi*x)  
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION VP
c      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION V0
c      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_left
      u_left = 0
C
*     FUNCTION u_right
      u_right = 0
C
*     FUNCTION v_left
      v_left = 0
C
*     FUNCTION v_right
      v_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
c*     FUNCTION u_x_left
c      u_x_left = ...     
C
c*     FUNCTION u_x_right
c      u_x_right = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit_u
      fit_u = u
c      fit_u = exp(-t*pi**4)*sin(pi*x)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
