C
C------------------------------------------------------
C
C     Problem:    PCB
C
C     Date:       05/05/99
C
C------------------------------------------------------
C
*     REAL CONSTANT
      s = 1.0E-10
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind_k = 1..17
      ind_y = 1..9
C
C-------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k(i), i in ind_k
      y(i), i in ind_y
      t 
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = -(k(1)+k(2)+k(3)+k(4))*y(1)
C
*     FUNCTION y2_t
      y2_t =k(1)*y(1)-(k(5)+k(6)+k(7))*y(2)
C
*     FUNCTION y3_t
      y3_t = k(2)*y(1) - (k(8) + k(9))*y(3)
C     
*     FUNCTION y4_t
      y4_t = k(3)*y(1) - (k(10) + k(11) + k(12))*y(4)
C
*     FUNCTION y5_t
      y5_t = k(4)*y(1) - k(13)*y(5)
C
*     FUNCTION y6_t
      y6_t = k(5)*y(2) + k(8)*y(3) - k(14)*y(6)
C
*     FUNCTION y7_t
      y7_t = k(6)*y(2) + k(10)*y(4) - k(15)*y(7)
C
*     FUNCTION y8_t
      y8_t = k(9)*y(3) + k(11)*y(4) - k(16)*y(8)
C
*     FUNCTION y9_t
      y9_t = k(7)*y(2) + k(12)*y(4) + k(13)*y(5) - k(17)*y(9)
C
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y0(i), i in ind_y
      if (i.eq.1) then
        y0(i) = 5.7916e-7/s
      else
        y0(i) = 0
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit(i), i in ind_y
      fit(i) = y(i)*s
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C






