C  
C------------------------------------------------------
C
C     Problem:    PB_CTRL1
C
C     Date:       26.07.2002
C  
C------------------------------------------------------
C  
*     REAL CONSTANT
      alpha = 1
      beta1 = 0.2
      beta2 = 0.05
      lambda = 0.5
C  
C------------------------------------------------------
C  
*     PARAMETER
      n = 50
C  
C------------------------------------------------------
C  
*     INDEX
      i
C  
C------------------------------------------------------
C  
*     SET OF INDICES
      ind = 1..n
      ind_perf = 1..5
C  
C------------------------------------------------------
C  
*     LININT tau
      0.0    0.0
      0.2    0.0
      0.6    0.4
      1.0    0.4
      1.4    0.2
      2.0    0.2
C  
C------------------------------------------------------
C  
*     MACRO u
      h = 2/n
      if (time.le.h) then
        u = a(1)
        goto 1001
      endif
      i = 1
 1002 continue
      ti = i*h   
      i = i+1  
      if ((time.le.ti+h).and.(time.ge.ti)) then
        u = a(i)
        goto 1001
      endif
      if (i.lt.n) then
        goto 1002
      endif      
 1001 continue     
C  
C------------------------------------------------------
C  
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a(j), j in ind
      Smax
      T, T_x, T_xx, x, time
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION T_t
      w = -beta1/(beta2+T)
      if (w.gt.10) then
        S = Smax*exp(10)
      else
        S = Smax*exp(w)
      endif
      T_t = alpha*T_xx + S
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION T_0
      if (time.lt.0.0001) then
        T_0 = 0
      else
        T_0 = T
      endif
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C  
C  *     FUNCTION v_t
C        v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C  
C  *     FUNCTION v_0
C        v_0 = ...
C  
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C  
C  *     FUNCTION T_left
C        T_left = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C   
*     FUNCTION T_x_left
      T_x_left = (T - u)/lambda
C  
*     FUNCTION T_x_right
      T_x_right = 0
C  
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C  
*     FUNCTION fit(j), j in ind_perf
      fit(j) = T - tau(time)
C  
*     FUNCTION control
      control = u
C  
*     FUNCTION goal
      goal = tau(time)
C  
C------------------------------------------------------
C
C   - Constraints (if exist):
C  
C  *     FUNCTION g1
C        g1 = ...
C  
C------------------------------------------------------
C  
*     END
C  
C------------------------------------------------------
C
