C
C------------------------------------------------------
C
C     Problem:    PAR_SIZE
C
C     Date:       20.1.2000
C
C------------------------------------------------------
C
*     PARAMETER
      NS = 30
      NS01 = 29 
      NS2 = 27   
C
C------------------------------------------------------
C
*     INDEX  
      I, J,K 
C
C------------------------------------------------------
C
*     SET OF INDICES
      IND = 1..NS
      IND1 = 2..NS   
      IND2 = 1..NS2
      IND3 = 1..NS01
      IND19 = 1..19
C
C------------------------------------------------------
C
*     REAL CONSTANT
      RP1  = 1.19863E-5
      SHEAR = 242.0
      RPAR(II) = RP1*(2.0**(1/3))**(II-1), II IN IND1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      CCON, DCON, PCON, YCON
      SPAR(II), II IN IND
      TIME
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION SPAR_P1
      AC = 1.294*SHEAR * CCON/DEXP(TIME/DCON)
      BC = PCON * SHEAR**YCON
      RATE1=0.0
      RATE2=0.0
      RATE3=0.0
      RATE4=0.0
      RATE5=0.0
      RATE6=0.0
C
      RATE4=AC*((RP1+RP1)**3)*SPAR(1)
      J = 2
  300 CONTINUE      
      RATE4=RATE4+AC*((RP1+RPAR(J))**3)*SPAR(J)
      J = J+1
      IF (J.LE.NS) THEN
        GOTO 300
      ENDIF              
      RATE4=-RATE4*SPAR(1)*1E12
      RATE6=2.0*BC*RPAR(2)*SPAR(2)  
      SPAR_P1 = RATE1+RATE2+RATE3+RATE4+RATE5+RATE6 
C
*     FUNCTION SPAR_P2
      RATE1=0.0
      RATE2=0.0
      RATE3=0.0
      RATE4=0.0
      RATE5=0.0
      RATE6=0.0
      RATE2=0.5*AC*((RP1+RP1)**3)*(SPAR(1))**2*1E12
      RATE3=0.5*AC*((RPAR(2)+RP1)**3)*SPAR(1)
      RATE3=-RATE3*SPAR(2)*1E12  
      J = 2
  400 CONTINUE
      RATE4=RATE4+AC*((RPAR(2)+RPAR(J))**3)*SPAR(J)
      J = J+1
      IF (J.LE.NS) THEN
        GOTO 400
      ENDIF
      RATE4=-RATE4*SPAR(2)*1E12
      RATE5=-BC*RPAR(2)*SPAR(2)
      RATE6=2.0*BC*RPAR(3)*SPAR(3)
      SPAR_P2 = RATE1+RATE2+RATE3+RATE4+RATE5+RATE6 
C
*     FUNCTION SPAR_P(II), II IN IND2
      RATE1=0.0
      RATE2=0.0
      RATE3=0.0
      RATE4=0.0
      RATE5=0.0
      RATE6=0.0
      I = II+2
      RATE1=2.0**(2-I)*AC*((RPAR(I-1)+RP1)**3)*SPAR(1)          
      J = 2                
  500 CONTINUE
      RATE1=RATE1+2.0**(J-I+1)*AC*((RPAR(I-1)+RPAR(J))**3)*SPAR(J)
      J = J+1
      IF (J.LE.I-2) THEN
        GOTO 500
      ENDIF
      RATE1=RATE1*SPAR(I-1)*1E12
      RATE2=0.5*AC*((RPAR(I-1)+RPAR(I-1))**3)*(SPAR(I-1))**2*1E12
      RATE3=2.0**(1-I)*AC*((RPAR(I)+RP1)**3)*SPAR(1)
      J = 2
  600 CONTINUE
      RATE3=RATE3+2.0**(J-I)*AC*((RPAR(I)+RPAR(J))**3)*SPAR(J)
      J = J+1
      IF (J.LE.I-1) THEN
        GOTO 600
      ENDIF
      RATE3=-RATE3*SPAR(I)*1E12
      J = I
  700 CONTINUE
      RATE4=RATE4+AC*((RPAR(I)+RPAR(J))**3)*SPAR(J)
      J = J+1
      IF (J.LE.NS) THEN
        GOTO 700
      ENDIF
      RATE4=-RATE4*SPAR(I)*1E12
      RATE5=-BC*RPAR(I)*SPAR(I)
      RATE6=2.0*BC*RPAR(I+1)*SPAR(I+1)
      SPAR_P(II) = RATE1+RATE2+RATE3+RATE4+RATE5+RATE6
C
C
*     FUNCTION SPAR_PNS     
      RATE1=0.0
      RATE2=0.0
      RATE3=0.0
      RATE4=0.0
      RATE5=0.0
      RATE6=0.0
      I = NS
      RATE1=2.0**(2-I)*AC*((RPAR(I-1)+RP1)**3)*SPAR(1)
      J = 2                 
  800 CONTINUE  
      RATE1=RATE1+2.0**(J-I+1)*AC*((RPAR(I-1)+RPAR(J))**3)*SPAR(J)
      J = J+1
      IF (J.LE.I-2) THEN
        GOTO 800
      ENDIF
      RATE1=RATE1*SPAR(I-1)*1E12
      RATE2=0.5*AC*((RPAR(I-1)+RPAR(I-1))**3)*(SPAR(I-1))**2*1E12
      RATE3=2.0**(1-I)*AC*((RPAR(I)+RP1)**3)*SPAR(1)
      J = 2
  900 CONTINUE
      RATE3=RATE3+2.0**(J-I)*AC*((RPAR(I)+RPAR(J))**3)*SPAR(J)
      J = J+1
      IF (J.LE.I-1) THEN
        GOTO 900
      ENDIF
      RATE3=-RATE3*SPAR(I)*1E12
      J = I
  950 CONTINUE
      RATE4=RATE4+AC*((RPAR(I)+RPAR(J))**3)*SPAR(J)
      J = J+1
      IF (J.LE.I) THEN
        GOTO 950
      ENDIF    
      RATE4=-RATE4*SPAR(I)*1E12
      RATE5=-BC*RPAR(I)*SPAR(I)
      SPAR_PNS = RATE1+RATE2+RATE3+RATE4+RATE5+RATE6
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION SPAR01
      SPAR01 = 1.72694
C
*     FUNCTION SPAR0(II), II IN IND3
      SPAR0(II) = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION RAVE
      RAVE = (SPAR(1)*RP1**2+SUM(SPAR(II)*RPAR(II)**2, II IN IND1))
     /                /(SPAR(1)*RP1+SUM(SPAR(II)*RPAR(II), II IN IND1))
C                                
*     FUNCTION SPAR_PLOT(II), II IN IND19
      SPAR_PLOT(II) = SPAR(II)           
c      
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
