C
C------------------------------------------------------
C
C     Problem:    PARTICLE
C
C     Date:       10.2.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      gamma = 20
      psi = 14.44
      beta = 0.02
      eps = 0.0000001
      alpha = -0.2
      alpha_hat = 10
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      T0, C0, T, C, Ts, Cs, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION T_t
      T_t = Ts
C
*     FUNCTION C_t
      C_t = Cs
C
*     FUNCTION T_tt
      T_tt = - psi**2*beta*C*exp(-gamma*(1-1/T)) - 2/(time+eps)*Ts 
c
C
*     FUNCTION C_tt
      C_tt = psi**2*C*exp(-gamma*(1-1/T)) - 2/(time+eps)*Cs 
c
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION T_0
      T_0 = T0
C
*     FUNCTION C_0
      C_0 = C0
C
*     FUNCTION Ts_0
      Ts_0 = 0
C
*     FUNCTION Cs_0
      Cs_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION T_fit
      T_fit = T
C
*     FUNCTION C_fit
      C_fit = C
C
*     FUNCTION Ts_fit
      Ts_fit = Ts 
C
*     FUNCTION Cs_fit
      Cs_fit = Cs
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION Ts_right
      Ts_right = Ts - alpha

*     FUNCTION Cs_right
      Cs_right = Cs - alpha_hat
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


