C
C------------------------------------------------------
C
C     Problem:    PARAB6
C
C     Date:       05.06.1999
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      q12, q11, q10, q22, q21, q20, u, u_x, u_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t
      q1s = q12*x**2 + q11*x + q10 
      q2s = q22*x**2 + q21*x + q20 
      f = (x**2 - x)*((-10*(2*t+4))
     /     - (20 + 80*(2*x-1))*(t**2+4*t+2))
      u_t = q1s*u_xx + q2s*u_x + f
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = -20*(x**2 - x)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION VP
c      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION V0
c      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_left
      u_left = 0
C
*     FUNCTION u_right
      u_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
C*     FUNCTION UXL
C      UXL = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit(i), i in ind
      fit(i) = u 
c      fit(i) = -10*(x**2-x)*(t**2+4*t+2)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
