C
C------------------------------------------------------
C
C     Problem:    PARAB2
C
C     Date:       05.06.1999
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      q1, q2, q3, v, w, v_x, w_x, v_xx, w_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION v_t
      v_t = q1*v_xx + 2/(1 + q3*w + v)
C
*     FUNCTION w_t
      w_t = q2*w_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION v_0
      if (x.le.0.5) then
         psi = 2*x 
      else
         psi = 2*(1 - x)
      endif
      v_0 = psi
C
*     FUNCTION w_0
      w_0 = psi
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION VP
c      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION V0
c      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION v_left
      v_left = 0
C
*     FUNCTION w_left
      w_left = 0
C
*     FUNCTION v_right
      v_right = 0
C
*     FUNCTION w_right
      w_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
C*     FUNCTION UXL
C      UXL = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit1
      fit1 = v
C
*     FUNCTION fit2
      fit2 = w
C
*     FUNCTION fit3
      fit3 = v
C
*     FUNCTION fit4
      fit4 = w
C
*     FUNCTION fit5
      fit5 = v
C
*     FUNCTION fit6
      fit6 = w
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
