C
C------------------------------------------------------
C
C     Problem:    PACK_BED
C
C     Date:       22.09.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.14
      v = 150
      dd = 3.81
      L = 45.72
      cin1 = 8.33E-8
      cin2 = 8.33E-8
      cbase1 = 8.33E-10
      cbase2 = 8.33E-10
      ka1 = 1.0E4
      ka2 = 1.0E4
      D = 50
      s0 = 1.8E-5
      eps = 0.5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      kd1, kd2
      c1, c2, s1, s2 
      c1_z, c2_z, s1_z, s2_z
      c1_zz, c2_zz, s1_zz, s2_zz 
      z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION c1_t
      U = 4*v/(eps*pi*dd**2)
      Pe = U*L/D
      tau = L/U
      eps1 = (1 - eps)/eps
      s = 1 - s1 - s2
      s1_rhs = ka1*tau*cin1*c1*s/(1+s1) - kd1*tau*s1/(1+s1)
      c1_t = -c1_z + c1_zz/Pe + eps1*s0/cin1*s1_rhs
C
*     FUNCTION c2_t
      s2_rhs = ka2*tau*cin2*c2*s/(1+s2) - kd2*tau*s2/(1+s2)
      c2_t = -c2_z + c2_zz/Pe + eps1*s0/cin2*s2_rhs
C
*     FUNCTION s1_t
      s1_t = s1_rhs
C
*     FUNCTION s2_t
      s2_t = s2_rhs
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION c1_0
      c1_0 = cbase1/cin1
C
*     FUNCTION c2_0
      c2_0 = cbase2/cin2
C
*     FUNCTION s1_0
      s1_0 = 0
C
*     FUNCTION s2_0
      s2_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
C*     FUNCTION u_left
C      u_left = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
*     FUNCTION c1_z_left
      c1_z_left = Pe*(c1 - 1)
C
*     FUNCTION c2_z_left
      c2_z_left = Pe*(c2 - 1)
C
*     FUNCTION c1_z_right
      c1_z_right = 0
C
*     FUNCTION c2_z_right
      c2_z_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION c1_fit
      c1_fit = c1
C
*     FUNCTION c2_fit
      c2_fit = c2
C
*     FUNCTION s1_fit
      s1_fit = s1
C
*     FUNCTION s2_fit
      s2_fit = s2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
