C
C------------------------------------------------------
C
C     Problem:    OZONE
C
C     Date:       24.11.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      y3 = 3.7E+16
      omega = pi/43200
      c2 = 7.601
      c4 = 22.62
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      qs1, qs2, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      q1 = qs1*1.0E-16
      q2 = qs2*1.0E-16
      if (sin(omega*t).gt.0) then
        q3 = exp(-c2/sin(omega*t))
      else
        q3 = 0
      endif
      if (sin(omega*t).gt.0) then
        q4 = exp(-c4/sin(omega*t))
      else
        q4 = 0
      endif
      y1_t = -q1*y1*y3 - q2*y1*y2 + 2*q3*y3 + q4*y2
C
*     FUNCTION y2_t
      y2_t = q1*y1*y3 - q2*y1*y2 - q4*y2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 1.0E+6
C
*     FUNCTION y2_0
      y2_0 = 1.0E+12
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


