C
C------------------------------------------------------
C
C     Problem:    OXIDAT
C
C     Date:       23.01.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      G=60000
      KT=0.9E-9  
      CAO=0.2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      N, CS, KR, CA, CO, CP, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CAP
      KLA=KT*(N**3)*(G**0.5)  
      RA=-KR*CA*CO     
      RO=0.5*RA   
      RP=-0.5*RA  
      CAP=RA  
C
*     FUNCTION COP
      COP=KLA*(CS-CO)+RO
C
*     FUNCTION CPP
      CPP=RP 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CA_0
      CA_0 = CAO
C
*     FUNCTION CO_0
      CO_0 = 0
C
*     FUNCTION CP_0
      CP_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CAFIT
      CAFIT = CA  
C
*     FUNCTION COFIT
      COFIT = CO
C
*     FUNCTION CPFIT
      CPFIT = CP
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
