C
C------------------------------------------------------
C
C     Problem:    OXENZ
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      G=60
      KS=5
      YOS=5
      YPS=1.5
      CLS=8
      KCL=0.5 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K, VM, S, CL, P, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION SP
      IF (T.LT.1) THEN
        N=30000
      ELSE
        IF (T.LT.2) THEN
          N=15000
        ELSE
          N=5000
        ENDIF
      ENDIF
      KLA=K*1.0E-13*(N**3)*(G**0.5)
      RS=(VM*S/(KS+S))*(CL/(KCL+CL)) 
      SP=-RS  
C
*     FUNCTION CLP
      CLP=KLA*(CLS-CL)-RS*YOS 
C
*     FUNCTION PP
      PP=RS*YPS   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION S_0
      IF (T.LT.0.0001) THEN
        S_0=100
      ELSE
        S_0=S
      ENDIF
C
*     FUNCTION  CL_0
      IF (T.LT.0.0001) THEN
        CL_0=8
      ELSE
        CL_0=CL
      ENDIF
C
*     FUNCTION P_0
      IF (T.LT.0.0001) THEN
        P_0=0
      ELSE
        P_0=P
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION S_fit
      S_fit=S
C
*     FUNCTION CL_fit
      CL_fit=CL
C
*     FUNCTION P_fit
      P_fit=P
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
