C
C------------------------------------------------------
C
C     Problem:    OXDYN
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      X=1.0   
      CLS=8 
      TF=2
      TE=10
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      QM, K0, CL, CF, CE, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CLP
      IF (T.LT.29) THEN
        KLA=0.0
      ELSE
        KLA=0.2
      ENDIF
      Q=QM*(CL/(K0+CL))   
      OUR=Q*X 
      CLP=KLA*(CLS-CL)-OUR
C
*     FUNCTION CFP
      CFP=(CL-CF)/TF  
C
*     FUNCTION CEP
      CEP=(CF-CE)/TE  
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CL_0
      IF (T.LT.1) THEN
        CL_0=8
      ELSE
        CL_0=CL
      ENDIF
C
*     FUNCTION CF_0
      IF (T.LT.1) THEN
        CF_0=8
      ELSE
        CF_0=CF
      ENDIF
C
*     FUNCTION CE_0
      IF (T.LT.1) THEN
        CE_0=8
      ELSE
        CE_0=CE
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CL_fit
      CL_fit=CL
C
*     FUNCTION CF_fit
      CF_fit=CF
C
*     FUNCTION CE_fit
      CE_fit=CE
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
