C
C------------------------------------------------------
C
C     Problem:    OSC_SOL
C
C     Date:       31.01.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      eps = 0.1
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..20
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a, b, u, v, w, u_x, v_x, w_x, u_xx, v_xx, w_xx
      fu, fv, fw, fu_x, fv_x, fw_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux_u
      flux_u = -a*u
C
*     FUNCTION flux_v
      flux_v = b*v
C
*     FUNCTION flux_w
      flux_w = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION u_t
      u_t = fu_x - u*v + w**2
C
*     FUNCTION v_t
      v_t = fv_x - u*v + w**2
C
*     FUNCTION w_t
      w_t = u*v - w**2
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION u_0
      u_0 = 0
      if ((x.le.5).and.(x.ge.3)) then
        u_0 = cos(pi*(x-4)/2)**2*(1 + sin(2*pi*(x-4)/eps))/2
      endif
C
*     FUNCTION v_0
      v_0 = 0
      if ((x.le.6).and.(x.ge.4)) then
        v_0 = cos(pi*(x-5)/2)**2*(1 + sin(2*pi*(x-5)/eps))/2
      endif
C
*     FUNCTION w_0
      w_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION u_left
      u_left = 0
C
*     FUNCTION v_left
      v_left = 0
C
*     FUNCTION w_left
      w_left = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(i), i in ind
      fit(i) = w
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




