C
C------------------------------------------------------
C
C     Problem:    OSC_REAC
C
C     Date:       20.09.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      f = 1
      scq = 1E-6
C
C------------------------------------------------------
C

C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      q, s, w, alpha, ita, rho, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION alpha_t
      alpha_t = s*(ita - alpha*ita + alpha - q*scq*alpha**2)
C
*     FUNCTION ita_t
      ita_t = (f*rho - ita - alpha*ita)/s
C
*     FUNCTION rho_t
      rho_t = w*(alpha - rho)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION alpha_0
      alpha_0 = 1
C
*     FUNCTION ita_0
      ita_0 = 600
C
*     FUNCTION rho_0
      rho_0 = 20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION alpha_fit
      alpha_fit = alpha
C
*     FUNCTION ita_fit
      ita_fit = ita
C
*     FUNCTION rho_fit
      rho_fit = rho
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
