C
C------------------------------------------------------
C
C     Problem:    OSCILL
C
C     Date:       03.15.97
C
C------------------------------------------------------
C
*     REAL CONSTANT 
      R = 1.987E-3
      Tmp = 440.0
      s = 1.0E+5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k8, k11, A, B, z, u, v, w, x, y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION zp
      k2 = 4.0E12*exp(-27.5/(R*Tmp))
      k3 = 1.0E14*exp((-37.5+24*v**2)/(R*Tmp))
      k4 = 2.20E4*exp(-8.0/(R*Tmp)) 
      k5 = 1.2E13*exp(-25/(R*Tmp))
      k6 = 2.4E4*exp(-8.5/(R*Tmp))
      k7 = 2.0E16*exp(-28.5/(R*Tmp))
      k10 = 2.0E9*exp(-14.5/(R*Tmp))
      k12 = 2.5E11*exp(-25.33/(R*Tmp))
      c = v/0.4 + x/0.4 + y/0.3
      if (c.ge.1) then
        zp = k11*s*(1-z)*(u**4 + w**4)
      else
        zp = -k12*(1-c)*z
      endif
C
*     FUNCTION up
      up = k1*s*A*(1-z-u-w) - k2*u - k4*z*u + zp*u/(1-z)
C
*     FUNCTION vp
      if (z.gt.0) then
        vp = k1*s*A*(z-u-y) - k3*v + k4*z*u - k10*v*y/z -zp*v/z
      else
        vp = 0
      endif
C
*     FUNCTION wp
      wp = k1*s*B*(1-z-u-w) - k5*w - k6*z*w + zp*w/(1-z)
C
*     FUNCTION xp
      d = z - v/0.61 - y/0.399
      if (d.ge.0) then
        E = d
      else
        E = 0
      endif
      if (z.gt.0) then
        xp = k6*z*w - k7*x*E/z - zp*x/z
      else
        xp = 0
      endif
C
*     FUNCTION yp
      if (z.gt.0) then  
        yp = k7*x*E/z + k8*s*B*E**2 - k10*v*y/z -zp*y/z
      else
        yp = 0
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION z0
      z0 = 0.92
C
*     FUNCTION u0
      u0 = 0.001
C
*     FUNCTION v0
      v0 = 0.6
C
*     FUNCTION w0
      w0 = 0.001
C
*     FUNCTION x0
      x0 = 0.0001
C
*     FUNCTION y0
      y0 = 0.0001
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION z_fit
      z_fit = z
C
*     FUNCTION u_fit
      u_fit = u
C
*     FUNCTION v_fit
      v_fit = v
C
*     FUNCTION w_fit
      w_fit = w
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
