C
C------------------------------------------------------
C
C     Problem:    OSCIL
C
C     Date:       1.02.2001
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      F = 10 
      V = 100
      CP = 1 
      RHO = 1
      Z1 = 1.0E+19   
      Z2 = 9.49E+12  
      E1 = 28000 
      E2 = 21000 
      H1 = -27000
      H2 = -20000
      TJ = 319.1 
      KC = 0.5   
      TSET = 350 
      U = 88.5   
      R = 1.987  
      ASTEAD = 3.14E-03   
      BSTEAD = 5.75E-04   
      TSTEAD = 333.4  
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A0, B0, T0, A, B, TR, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION AP
      K1 = Z1*EXP(-E1/(R*TR)) 
      K2 = Z2*EXP(-E2/(R*TR)) 
      AP = F*(A0-A)/V-K1*A*A-K2*A 
C
*     FUNCTION BP
      BP = F*(B0-B)/V+K1*A*A  
C
*     FUNCTION TRP
      RH = (-1)*(H1*K1*A*A+H2*K2*A)/(CP*RHO)  
      U1 = U+KC*(TR-TSET) 
      TRP = F*(T0-TR)/V-U1*(TR-TJ)/(V*CP*RHO)+RH
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION A_0
      A_0 = 0  
C
*     FUNCTION B_0
      B_0 = 0  
C
*     FUNCTION TR_0
      TR_0 = T0  
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION ADIM
      ADIM = A/ASTEAD 
C
*     FUNCTION BDIM
      BDIM = B/BSTEAD 
C
*     FUNCTION TDIM
      TDIM = TR/TSTEAD
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
