C
C------------------------------------------------------
C
C     Problem:    OSC2INTM
C
C     Date:       30.03.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k3 = 2.5e9
      st = 100
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k4, y1, y2, y3, y4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      g1 = k1*y1
      g2 = k2*y2
      g3 = k3*y2*y3*y3
      g4 = k4*y3
      y1_t = -g1*st
C
*     FUNCTION y2_t
      y2_t = (-g2 - g3 + g1)*st
C
*     FUNCTION y3_t
      y3_t = (g3 - g4 + g2)*st
C
*     FUNCTION y4_t
      y4_t = g4*st
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 0.1
C
*     FUNCTION y2_0
      y2_0 = 0.5e-5
C
*     FUNCTION y3_0
      y3_0 = 0.0001
C
*     FUNCTION y4_0
      y4_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     FUNCTION y4_fit
      y4_fit = y4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

