C
C------------------------------------------------------
C
C     Problem:    OREGO
C 
C     Date:       06.01.1995
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A, B, C, Y1, Y2, Y3, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P = A*(Y2 + Y1*(1 - B*0.000001*Y1 - Y2))
C
*     FUNCTION Y2P
      Y2P = (Y3 - (1 + Y1)*Y2)/A
C
*     FUNCTION Y3P
      Y3P = C*(Y1 - Y3)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = 1
C
*     FUNCTION Y20
      Y20 = 2
C
*     FUNCTION Y30
      Y30 = 3
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y1FIT
      Y1FIT = Y2
C
*     FUNCTION Y2FIT
      Y2FIT = Y3
C
*     FUNCTION Y3FIT
      Y3FIT = Y1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C







