C
C------------------------------------------------------
C
C     Problem:    ORB_MOTN
C
C     Date:       22.11.2001
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      GM, x0, vy0, x, y, vx, vy, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      x_t = vx
C
*     FUNCTION y_t
      y_t = vy
C
*     FUNCTION vx_t
      d1 = x**2 + y**2
      if (d1.gt.0) then
        d = sqrt(d1)**3
      else
        d = 1
      endif
      vx_t = -GM*x/d
C
*     FUNCTION vy_t
      vy_t = -GM*y/d
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = x0
C
*     FUNCTION y_0
      y_0 = 0
C
*     FUNCTION vx_0
      vx_0 = 0
C
*     FUNCTION vy_0
      vy_0 = vy0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION y_fit
      y_fit = y
C
*     FUNCTION vx_fit
      vx_fit = vx
C
*     FUNCTION vy_fit
      vy_fit = vy
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

