C
C------------------------------------------------------
C
C     Problem:    ORBIT
C
C     Date:       23.04.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R0 = 0.1405
      m0 = 1.0
      mp = -0.07487
      gamma = 1.0
C
C------------------------------------------------------
C
*     MACRO u
      u = u1 + u2*t + u3*t**2 + u4*t**3 + u5*t**4
     /      + u6*t**5 + u7*t**6+ u8*t**7
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      T_end
      u1, u2, u3, u4, u5, u6, u7, u8
      x1, x2, x3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = T_end*x2                   
C
*     FUNCTION x2_t
      x2_t = T_end*(x3**2/x1 - gamma/x1**2
     /       + R0*sin(u)/(m0 + mp*T_end*t))
C
*     FUNCTION x3_t
      x3_t = T_end*(-x2*x3/x1 + R0*cos(u)/(m0 + mp*T_end*t))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 1.0
C
*     FUNCTION x2_0
      x2_0 = 0.0
C
*     FUNCTION x3_0
      x3_0 = 1.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION T_fit
      T_fit = sqrt(T_end)
C
*     FUNCTION u_fit
      u_fit = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


