C
C------------------------------------------------------
C
C     Problem:    OPT_KINX
C
C     Date:       06.02.1997
C
C------------------------------------------------------
C
*     PARAMETER
      m = 50
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind_m = 1..m
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k12 = 0.1
      k23 = 0.055
      V2 = 7.0
      c2_lower = 3.0
      c2_upper = 5.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      D1, D2, k0, t1, t2, t3, t
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION c2
      y2_t1 = k0/k23*(1 - EXP(-k23*t1)) 
      y2_t2 = y2_t1*EXP(-k23*(t2-t1)) 
      a1 = y2_t2 - k12*D1/(k23 - k12)
      b1 = k12*D1/(k23 - k12)
      y2_t3 = a1*EXP(-k23*(t3-t2)) + b1*EXP(-k12*(t3-t2)) 
      a2 = y2_t3 - k12*D2/(k23 - k12)
      b2 = k12*D2/(k23 - k12)
      IF (t.LE.t1) THEN
        c2 = k0/k23*(1 - EXP(-k23*t))/V2
      ELSE
        IF (t.LE.t2) THEN
          c2 = y2_t1*EXP(-k23*(t-t1))/V2
        ELSE
          IF (t.LE.t3) THEN
            c2 = (a1*EXP(-k23*(t-t2)) + b1*EXP(-k12*(t-t2)))/V2
          ELSE
            c2 = (a2*EXP(-k23*(t-t3)) + b2*EXP(-k12*(t-t3)))/V2
          ENDIF
        ENDIF
      ENDIF
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION gt_1
      gt_1 = t2 - t1
C
*     FUNCTION gt_2
      gt_2 = t3 - t2
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

