C
C------------------------------------------------------
C
C     Problem:    OPT_KIN
C
C     Date:       06.02.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k12 = 0.1
      k23 = 0.055
      V2 = 7.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      D1, D2, k0, t1, t2, t3, y1, y2, t
C
C------------------------------------------------------
C
C   - Right-hand side of ODE:
C
*     FUNCTION y1_p
      y1_p = -k12*y1    
C
*     FUNCTION y2_p
      IF (t.lt.t1) THEN
        y2_p = k12*y1 - k23*y2 + k0
      ELSE
        y2_p = k12*y1 - k23*y2 
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values of ODE:
C
*     FUNCTION y1_0
      IF (t.LT.t2) THEN
        y1_0 = 0.0
      ELSE
        IF (t.LT.t3) THEN
          y1_0 = D1
        ELSE
          y1_0 = y1 + D2
        ENDIF
      ENDIF
C
*     FUNCTION y2_0
      IF (t.LT.t1) THEN
        y2_0 = 0.0
      ELSE
        y2_0 = y2
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2/V2
C
C------------------------------------------------------
C
C   - Constraints:
C
*     FUNCTION g1
      g1 = t2 - t1
C
*     FUNCTION g2
      g2 = t3 - t2
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
