C
C------------------------------------------------------
C
C     Problem:    OPT_CTRL
C
C     Date:       31.05.2002
C
C------------------------------------------------------
C       
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a10, a11, a12, a13, a14, a15, a16
      a20, a21, a22, a23, a24, a25, a26
      a30, a31, a32, a33, a34, a35, a36
      x1, x2, x3, x4, x5, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      u1 = a10 + a11*t + a12*t**2 + a13*t**3 + a14*t**4 
     /                                   + a15*t**5 + a16*t**6
      u2 = a20 + a21*t + a22*t**2 + a23*t**3 + a24*t**4 
     /                                   + a25*t**5 + a26*t**6
      u3 = a30 + a31*t + a32*t**2 + a33*t**3 + a34*t**4 
     /                                   + a35*t**5 + a36*t**6
      x1_t = x2 + cos(2*t) + t*u1 + exp(t**2)*u2 + t**2*u3
C
*     FUNCTION x2_t
      x2_t = -x1 + sin(5*t) + t**2*u2
C
*     FUNCTION x3_t
      x3_t = x3 + exp(t) + 2*t*u1 + t*u3
C
*     FUNCTION x4_t
      x4_t = 2*x4 + sin(10*t) + t**2*u1 + cos(3*t*u2) + 4*t*u3
C
*     FUNCTION x5_t
      x5_t = (t**4*x1 + sin(t*x2) + (4*t-1)*x3 
     /                    + 3*exp(-t)*x4 - cos(4*t))**2
     /      + (3+t)*u1**2 + u1*u2 + 2*u1*u3 + (4+t**2)*u2**2
     /      + (3+t**2)*u3**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 1
C
*     FUNCTION x2_0
      x2_0 = -1
C
*     FUNCTION x3_0
      x3_0 = 0
C
*     FUNCTION x4_0
      x4_0 = -2
C
*     FUNCTION x5_0
      x5_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION x5_fit
      x5_fit = x5*0.001
C
*     FUNCTION u1_ctrl
      u1_ctrl = a10 + a11*t + a12*t**2 + a13*t**3 + a14*t**4 
     /                                   + a15*t**5 + a16*t**6
C
*     FUNCTION u2_ctrl
      u2_ctrl = a20 + a21*t + a22*t**2 + a23*t**3 + a24*t**4 
     /                                   + a25*t**5 + a26*t**6
C
*     FUNCTION u3_ctrl
      u3_ctrl = a30 + a31*t + a32*t**2 + a33*t**3 + a34*t**4 
     /                                   + a35*t**5 + a36*t**6
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = x1 + 1 
C
*     FUNCTION g2
      g2 = x2 - 0.5
C
*     FUNCTION g3
      g3 = x3 + 2 
C
*     FUNCTION g4
      g4 = x4 - 1 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
