C
C------------------------------------------------------
C
C     Problem:    BRYSON
C
C     Date:       20.01.1997
C
C------------------------------------------------------
C
*     MACRO u
      if (t.lt.t1) then
        u = a*t + b
      else
        if (t.lt.t2) then
          u = a*t1 + b
        else
          u = a*t1*(1 - t)/(1 - t2) + b
        endif
      endif
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, t1, t2, x, v, w, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_p
      x_p = v
C
*     FUNCTION v_p
      v_p = u
C
*     FUNCTION w_p
      w_p = 0.5*u**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 0.0
C
*     FUNCTION v_0
      v_0 = 1.0
C
*     FUNCTION w_0
      w_0 = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION v_fit
      v_fit = v
C
*     FUNCTION w_fit
      w_fit = w
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION res1
      res1 = t2 - t1
C
*     FUNCTION res2
      res2 = 1.0 - t2
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
