C  
C------------------------------------------------------
C  
C     Problem:    OPT_CON
C  
C     Date:       23.07.2002
C  
C------------------------------------------------------
C  
*     PARAMETER
      n = 50
C  
C------------------------------------------------------
C  
*     INDEX
      i
C  
C------------------------------------------------------
C  
*     SET OF INDICES
      ind = 1..n                
*     MACRO u
      h = 1/n
      if (t.le.h) then
        u = a(1)
        goto 1001
      endif
      i = 1
 1002 continue
      ti = i*h   
      i = i+1  
      if ((t.le.ti+h).and.(t.ge.ti)) then
        u = a(i)
        goto 1001
      endif
      if (i.lt.n) then
        goto 1002
      endif      
 1001 continue           
C  
C------------------------------------------------------
C  
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a(j), j in ind
      x1, x2, x3, x4, x5, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = x2
C
*     FUNCTION x2_t
      x2_t = -x3*u + 16*x5 - 8
C  
*     FUNCTION x3_t
      x3_t = u
C  
*     FUNCTION x4_t
      x4_t = x1**2 + x2**2 + 0.0005*(x2 + 16*x5 - 8 - 0.1*x3*u**2)**2
C  
*     FUNCTION x5_t
      x5_t = 1
C  
C------------------------------------------------------
C  
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C  
*     FUNCTION x1_0
      if (t.lt.0.000001) then
        x1_0 = 0
      else
        x1_0 = x1
      endif
C  
*     FUNCTION x2_0
      if (t.lt.0.000001) then
        x2_0 = -1
      else
        x2_0 = x2
      endif
C  
*     FUNCTION x3_0
      if (t.lt.0.000001) then
        x3_0 = -sqrt(5)
      else
        x3_0 = x3
      endif
C  
*     FUNCTION x4_0
      if (t.lt.0.000001) then
        x4_0 = 0
      else
        x4_0 = x4
      endif
C  
*     FUNCTION x5_0
      if (t.lt.0.000001) then
        x5_0 = 0
      else
        x5_0 = x5
      endif
C  
C------------------------------------------------------
C  
C   - Fitting criteria:
C  
*     FUNCTION x1_plot
      x1_plot = x1
C  
*     FUNCTION x2_plot
      x2_plot = x2
C  
*     FUNCTION x3_plot
      x3_plot = x3
C  
*     FUNCTION x4_plot
      x4_plot = x4
C  
*     FUNCTION x5_plot
      x5_plot = x5
C  
*     FUNCTION perf_index
      perf_index = sqrt(x4)
C  
*     FUNCTION control
      control = u
C  
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
