C
C------------------------------------------------------
C
C     Problem:    ON_OFF4
C
C     Date:       23.12.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      L1 = 500
      L2=1.0e7
C
C----------------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1p, k1m, r0, y10, k13, k31, k2p, k2m, y4_tau, tau
      y1,  y2, y3, y4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_p
      y1_p = k1p*(r0-y1)*(L1-y1) - (k1m+k13)*y1 + k31*y3
C
*     FUNCTION y2_p  
      if (t.le.tau) then
        y2_p = k1p*(r0-y2)*(L1-y2) - k1m*y2
      else
        y2_p = k1p*(r0-y2-y4)*(L1-y2) - k1m*y2
      endif
C
*     FUNCTION y3_p
      y3_p = k13*y1-k31*y3
C
*     FUNCTION y4_p
      if (t.le.tau) then
        y4_p = 0
      else
        y4_p = k2p*(r0-y2-y4)*(L2-y4) - k2m*y4
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      if (t.lt.tau) then
        y1_0 = y10
      else
        y1_0 = y1
      endif
C
*     FUNCTION y2_0
      if (t.lt.tau) then
        y2_0 = y10
      else
        y2_0 = y2
      endif
c
*     FUNCTION y3_0
      if (t.lt.tau) then
        y3_0 = 0
      else
        y3_0 = y3
      endif
C
*     FUNCTION y4_0
      if (t.lt.tau) then
        y4_0 = 0
      else
        y4_0 = y4_tau
      endif
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     END
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
