C
C------------------------------------------------------
C
C     Problem:    ON_OFF2
C
C     Date:       23.12.1997
C
C------------------------------------------------------
C
*     PARAMETER
      n_const = 60
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n_const
C
C------------------------------------------------------
C
*     REAL CONSTANT
      L = 1.0E+7
      tau = 2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1p, k1m, r0, k2p, k2m, L1, y10, y_tau
      y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_p  
      if (t.le.tau) then
        y1_p = k1p*(r0-y1)*(L1-y1) - k1m*y1
      else
        y1_p = k1p*(r0-y1-y2)*(L1-y1) - k1m*y1
      endif
C
*     FUNCTION y2_p
      if (t.le.tau) then
        y2_p = 0
      else
        y2_p = k2p*(r0-y1-y2)*(L-y2) - k2m*y2
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      if (t.lt.tau) then
        y1_0 = y10
      else
        y1_0 = y1
      endif
C
*     FUNCTION y2_0
      if (t.lt.tau) then
        y2_0 = 0
      else
        y2_0 = y_tau
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g(i), i in ind
      g(i) = r0-y1-y2
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
