C
C------------------------------------------------------
C
C     Problem:    ON_OFF1
C
C     Date:       1.2.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      L10=100.0
      L20=200.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1p, K2p, K1m, K2m, R0, T2, T1, Y1, Y2, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      IF (T.GE.T1) THEN
         Y1P = K1p*(R0 - Y1 - Y2)*(L10 - Y1) - K1m*Y1
      ELSE
         Y1P=0.0
      ENDIF
C
*     FUNCTION Y2P
      IF (T.GE.T2) THEN
         Y2P = K2p*(R0 - Y1 - Y2)*(L20 - Y2) - K2m*Y2
      ELSE
         Y2P=0.0
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      IF (T.LE.0.00001) THEN
        Y10 = 0.0
      ELSE
        Y10 = Y1
      ENDIF  
C
*     FUNCTION Y20
      IF (T.LE.0.00001) THEN
        Y20 = 0.0
      ELSE
        Y20 = Y2
      ENDIF  
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y1FIT
      Y1FIT = Y1 + Y2
C
C------------------------------------------------------
C
C   - Constraint:
C
*     FUNCTION G
      G = T1 - T2 - 0.001
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
