C
C------------------------------------------------------
C
C     Problem:    OLIGO
C
C     Date:       02.07.98
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      LA0, KI, K1, K2, LA, GA, TR, GL, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION LAP
      LAP = -KI*LA - K1*LA*GA + K2*TR
C
*     FUNCTION GAP
      GAP = -K1*LA*GA + KI*LA + K2*TR
C
*     FUNCTION TRP
      TRP = -K2*TR + K1*LA*GA
C
*     FUNCTION GLP
      GLP = KI*LA
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION LA1
      LA1 = LA0
C
*     FUNCTION GA0
      GA0 = 0
C
*     FUNCTION TR0
      TR0 = 0
C
*     FUNCTION GL0
      GL0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION LAFIT
      LAFIT = LA
C
*     FUNCTION GAFIT
      GAFIT = GA
C
*     FUNCTION TRFIT
      TRFIT = TR
C
*     FUNCTION GLFIT
      GLFIT = GL
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
