C
C------------------------------------------------------
C
C     Problem:    OIL
C
C     Date:       28.05.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT 
      UA = 1200
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..5
C
C------------------------------------------------------
C
*     TABLE a(i), i in ind
      1   8.86
      2  24.25
      3  23.67
      4  18.75
      5  20.70
C
*     TABLE b(i), i in ind
      1  10215.4
      2  18820.5
      3  17008.9
      4  14190.8
      5  15599.8
C
C------------------------------------------------------
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      d1, d2, d3, d4, x1, x2, x3, x4, Temp, TempJ, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      k1 = exp(a(1) - b(1)/Temp)
      k2 = exp(a(2) - b(2)/Temp)
      k3 = exp(a(3) - b(3)/Temp)
      k4 = exp(a(4) - b(4)/Temp)
      k5 = exp(a(5) - b(5)/Temp)
      x1_t = -k1*x1 - (k3 + k4 + k5)*x1*x2
C
*     FUNCTION x2_t
      x2_t = k1*x1 - k2*x2 + k3*x1*x2
C
*     FUNCTION x3_t
      x3_t = k2*x2 + k4*x1*x2
C
*     FUNCTION x4_t
      x4_t = k5*x1*x2
C
*     FUNCTION Temp_t
      Cp = 1.16*x1 + 0.827*(1 - x1) + 
     /          (3.4*x1 + 0.92*(1 - x1))*(Temp - 298)*1E-3
      rho = d1*x1 + d2*x2 + d3*x3 + d4*x4
      Temp_t = (602.4*k1*x1 - 0.833*UA/rho*(Temp - TempJ))/Cp
C
*     FUNCTION TempJ_t
      if ((t.ge.4.5).and.(t.le.6)) then
        u1 = 0
        u2 = 5
      else
        if (t.lt.4.5) then
          u1 = 5
          u2 = 0
        else
          u1 = 0
          u2 = 0
        endif
      endif
      TempJ_t = u1*(873 - TempJ) + u2*(373 - TempJ) 
     /                       + 0.01357*UA*(Temp - TempJ)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.0.001) then
        x1_0 = 1
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.0.001) then
        x2_0 = 0
      else
        x2_0 = x2
      endif
C
*     FUNCTION x3_0
      if (t.lt.0.001) then
        x3_0 = 0
      else
        x3_0 = x3
      endif
C
*     FUNCTION x4_0
      if (t.lt.0.001) then
        x4_0 = 0
      else
        x4_0 = x4
      endif
C
*     FUNCTION Temp_0
      if (t.lt.0.001) then
        Temp_0 = 698.15
      else
        Temp_0 = Temp
      endif 
C
*     FUNCTION TempJ_0
      if (t.lt.0.001) then
        TempJ_0 = 698.15
      else
        TempJ_0 = TempJ
      endif 
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION Temp_fit
      Temp_fit = Temp
C
*     FUNCTION TempJ_fit
      TempJ_fit = TempJ
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




