C
C------------------------------------------------------
C
C     Problem:    OEKOSYS
C
C     Date:       04.02.1997
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      p1, p2, p3, p4, p5, p6, p7, p8, x1, x2, x3, t

C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_p
      x1_p = p1*x1 - p2*x1*x3 - p3*x1**2
C
*     FUNCTION x2_p
      x2_p = p4*x2 - p5*x2*x3 - p6*x2**2
C
*     FUNCTION x3_p
      x3_p = 0.05*p2*x1*x3 + 0.03333333*p5*x2*x3 - p7*x3 - p8*x3**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 50000.0
C
*     FUNCTION x2_0
      x2_0 = 50000.0
C
*     FUNCTION x3_0
      x3_0 = 2500.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
