C
C------------------------------------------------------
C
C     Problem:    OC_EX4
C
C     Date:       23.04.97
C
C------------------------------------------------------
C
*     MACRO u
      IF (t.LT.ts) THEN
        u = -0.8
      ELSE
        u = 0.8
      ENDIF
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      ts, x, xp, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      x_t = xp
C
*     FUNCTION xp_t
      xp_t = u - x + xp
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      IF (t.GT.0.0001) THEN
        x_0 = x
      ELSE
        x_0 = 0.231
      ENDIF
C
*     FUNCTION xp_0
      IF (t.GT.0.0001) THEN
        xp_0 = xp
      ELSE
        xp_0 = 1.126
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION xp_fit
      xp_fit = xp
C
*     FUNCTION u_fit
      u_fit = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
