C
C------------------------------------------------------
C
C     Problem:    OC_EX3
C
C     Date:       23.04.97
C
C------------------------------------------------------
C
*     MACRO u
      u = u1 + u2*t + u3*t**2 + u4*t**3 + u5*t**4
     /      + u6*t**5  
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      u1, u2, u3, u4, u5, u6
      x1, x2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = 0.78*(-2*(x1 + 0.25) - (x1 + 0.25)*u
     /       + (x2 + 0.5)*exp(25*x1/(x1+2)))
C
*     FUNCTION x2_t
      x2_t = 0.78*(0.5 - x2 - (x2 + 0.25)*exp(25*x1/(x1+2)))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 0.05
C
*     FUNCTION x2_0
      x2_0 = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION u_fit
      u_fit = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
