C
C------------------------------------------------------
C
C     Problem:    OBST_CTL
C
C     Date:       28.12.2006
C
C------------------------------------------------------
C
*     PARAMETER
      n = 29
C
C------------------------------------------------------
C
*     INDEX
      i
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
C
C------------------------------------------------------
C
*     REAL CONSTANT
      ubar = 1
      B = ubar/1.9
C
C------------------------------------------------------
C
*     TABLE tbreak(j), j in ind
      1  0.1
      2  0.2
      3  0.3
      4  0.4
      5  0.5
      6  0.6
      7  0.7
      8  0.8
      9  0.9
      10 1.0
      11 1.1
      12 1.2
      13 1.3
      14 1.4
      15 1.5
      16 1.6
      17 1.7
      18 1.8
      19 1.9
      20 2.0
      21 2.1
      22 2.2
      23 2.3
      24 2.4
      25 2.5
      26 2.6
      27 2.7
      28 2.8      
      29 2.9
C
C------------------------------------------------------
C
*     MACRO contrl
      i = n
      contrl = u(i)
      if (t.ge.tbreak(i)) then
        goto 100
      endif
  101 continue
      if (t.ge.tbreak(i-1)) then
        contrl = u(i-1) + 
     /     (t - tbreak(i-1))/(tbreak(i)-tbreak(i-1))
     /         *(u(i)-u(i-1))
        goto 100 
      endif
      i = i-1
      if (i.gt.1) then
        goto 101  
      endif
      contrl = u(1)
  100 continue
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      u(j), j in ind
      x1, x2, x3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = x2
C
*     FUNCTION x2_t
      x2_t = contrl - 0.1*(1 + 2*x1**2)*x1
C
*     FUNCTION x3_t
      x3_t = 9*(x1 - 1)**2 + ((x2 - 0.4)/0.3)**2 - 1
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.eq.0) then
        x1_0 = 1
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.eq.0) then
        x2_0 = 1
      else
        x2_0 = x2
      endif
C
*     FUNCTION x3_0
      if (t.eq.0) then
        x3_0 = 3
      else
        x3_0 = x3
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = sqrt(5)*x1 
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION u_plot
      u_plot = contrl
C
C------------------------------------------------------
C
C   - Constraints:
C      
*     FUNCTION g(j), j in ind
      g(j) = x2 + 0.8
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


