C
C------------------------------------------------------
C
C     Problem:    NUTRITI
C
C     Date:       21.2.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      k = 0.5
      m = 0.5
      q = 1
      w = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, c, d, x, y, l, n, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      f = 1 + q*sin(2*pi*w*t)
      s = n/(k + n)*f
      x_t = a*x*s - c*x
C
*     FUNCTION y_t
      y_t = b*y*s - d*y
C
*     FUNCTION l_t
      l_t = c*x + d*y - m*l*f
C
*     FUNCTION n_t
      n_t = m*l*f - a*x*s - b*y*s
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 0.1
C
*     FUNCTION y_0
      y_0 = 0.1
C
*     FUNCTION l_0
      l_0 = 0.1
C
*     FUNCTION n_0
      n_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

