C
C------------------------------------------------------
C
C     Problem:    NTA2
C
C     Date:       05.06.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Ks = 2.28E-02

C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Vs1, Y, Ve1, L, M1, N1, kd, c0, D, sf
      s, e, c, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION s_t
      Ve = Ve1*1E-6
      M = M1*1E+6
      Vs = Vs1*1E+4
      N = N1*1E+10
      w = e*s/(Ks + s)
      s_t = D*(sf - s) - Vs*w*c
C
*     FUNCTION e_t
      e_t = Ve*(1 + M*w + N*w**2)/(L + M*w + N*w**2)
     \       - (Y*Vs*w + kd)*e
C
*     FUNCTION c_t
      c_t = (Y*Vs*w - D)*c
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION s_0
      if (t.lt.0.1) then
        s_0 = 0
      else
        s_0 = s
      endif
C
*     FUNCTION e_0
      if (t.lt.0.1) then
        Ve = Ve1*1E-6
        e_0 = Ve/L/kd
      else
        e_0 = e
      endif
C
*     FUNCTION c_0
      if (t.lt.0.1) then
        c_0 = c0
      else
        c_0 = c
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION c_fit
      c_fit = c
C
*     FUNCTION s_fit
      s_fit = s
C
*     FUNCTION e_fit
      e_fit = e
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

