C
C------------------------------------------------------
C
C     Problem:    NOSTR
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      C0 = 1 
      V = 10 
      FRAC1 = 0.5
      FRAC2 = 0.25   
      ALPHA = 5  
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      F, K, C1, C2, C4, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION C1P
      F1 = F*(1-FRAC1)
      F2 = F*FRAC1
      V1 = V*(1-FRAC2)
      V2 = V*FRAC2
      F3 = ALPHA*F
      C1P = (F1*(C0-C1)+F3*(C2-C1)-K*V1*C1)/V1
C
*     FUNCTION C2P
      C2P = (F3*(C1-C2)-K*V*C2)/V2
C
*     FUNCTION C4P
      C4P = (F*(C0-C4)-K*V*C4)/V  
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION C1_0
      C1_0 = 0
C
*     FUNCTION C2_0
      C2_0 = 0
C
*     FUNCTION C4_0
      C4_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X3
      F1 = F*(1-FRAC1)
      F2 = F*FRAC1
      V1 = V*(1-FRAC2)
      V2 = V*FRAC2
      F3 = ALPHA*F
      C3 = (F1*C1+F2*C0)/F
      X3 = (C0-C3)/C0 
C
*     FUNCTION X4
      X4 = (C0-C4)/C0 
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
