C
C------------------------------------------------------
C
C     Problem:    NON_KIN
C
C     Date:       12.12.1996
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k12, k21, R10, R20, P1, P2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dP1
      dP1 = k1*(R10 - P1)*(k2 - k21*P1 - k21*P2 + k21*R10
     /      + k21*R20)
C
*     FUNCTION dP2
      dP2 = k2*(R20 - P2)*(k1 - k12*P1 - k12*P2 + k12*R10
     /      + k12*R20)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION P10
      P10 = 0.0
C
*     FUNCTION P20
      P20 = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION P1FIT
      P1FIT = P1
C
*     FUNCTION P2FIT
      P2FIT = P2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
