C
C------------------------------------------------------
C
C     Problem:    NON_ISO
C
C     Date:       02.10.2001
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      alpha, beta, c, Temp, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION c_t
      k = beta*Temp**2
      c_t = 1 - c - k*c
C
*     FUNCTION Temp_t
      Temp_t = 1 - Temp - alpha*k*c
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION c_0
      c_0 = 1
C
*     FUNCTION Temp_0
      Temp_0 = 0.1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION c_fit
      c_fit = c 
C
*     FUNCTION Temp_fit
      Temp_fit = Temp
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

