C
C------------------------------------------------------
C
C     Problem:    NL_CSTR
C
C     Date:       15.05.2002
C
C------------------------------------------------------
C
*     CONINT u1
      0.0    0.0
      0.02  15.0
      0.04  13.0
      0.05  20.0
      0.06   7.0 
      0.09   0.0
      0.15  20.0
C
*     CONINT u2
      0.0    0.0
      0.06   5.0
      0.075  0.0
      0.16   5.0
C
*     SPLINE u3
      0.0    2.0
      0.02   3.0
      0.05   1.4
      0.075  0.0
      0.15   3.0
      0.175  1.4
      0.2    0.0
C
*     CONINT u4
      0.0   20.0
      0.06   0.0
      0.125 20.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, k5, k6, k7, k8, k9, k10
      z1, z2, z3, z4, z5, z6, z7, z8, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION z1_t
      u = u1(t) + u2(t) + u4(t)
      z1_t = u4(t) - u*z1 - k1*z1*z2 - k2*z1*z6*u3(t)
C
*     FUNCTION z2_t
      z2_t = u1(t) - u*z2 - k1*z1*z2 - k3*z2*z3
C
*     FUNCTION z3_t
      z3_t = u2(t) - u*z3 - k4*z2*z3
C
*     FUNCTION z4_t
      z4_t = -u*z4 + 2*k1*z1*z2 - k5*z4*z5
C
*     FUNCTION z5_t
      z5_t = -u*z5 + k6*z2*z3 - k5*z4*z5
C
*     FUNCTION z6_t
      z6_t = -u*z6 + k7*z4*z5 - k2*z1*z6*u3(t)
C
*     FUNCTION z7_t
      z7_t = -u*z7 + 2*k2*z1*z6*u3(t)
C
*     FUNCTION z8_t
      z8_t = 5.8*(u*z1 - u4(t)) - 3.7*u1(t) - 4.1*u2(t)
     /   + u*(k2*z4 + k8*z5 + k9*z6 + k10*z7) - 5*u3(t)**2 - 0.09
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION z1_0
      if (t.lt.0.0001) then
        z1_0 = 0.1883
      else
        z1_0 = z1
      endif
C
*     FUNCTION z2_0
      if (t.lt.0.0001) then
        z2_0 = 0.2507
      else
        z2_0 = z2
      endif
C
*     FUNCTION z3_0
      if (t.lt.0.0001) then
        z3_0 = 0.0467
      else
        z3_0 = z3
      endif
C
*     FUNCTION z4_0
      if (t.lt.0.0001) then
        z4_0 = 0.0899
      else
        z4_0 = z4
      endif
C
*     FUNCTION z5_0
      if (t.lt.0.0001) then
        z5_0 = 0.1804 
      else
        z5_0 = z5
      endif
C
*     FUNCTION z6_0
      if (t.lt.0.0001) then
        z6_0 = 0.1394
      else
        z6_0 = z6
      endif
C
*     FUNCTION z7_0
      if (t.lt.0.0001) then
        z7_0 = 0.1046
      else
        z7_0 = z7
      endif
C
*     FUNCTION z8_0
      if (t.lt.0.0001) then
        z8_0 = 0
      else
        z8_0 = z8
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION z1_fit
      z1_fit = z1
C
*     FUNCTION z2_fit
      z2_fit = z2
C
*     FUNCTION z3_fit
      z3_fit = z3
C
*     FUNCTION z4_fit
      z4_fit = z4
C
*     FUNCTION z5_fit
      z5_fit = z5
C
*     FUNCTION z6_fit
      z6_fit = z6
C
*     FUNCTION z7_fit
      z7_fit = z7
C
*     FUNCTION z8_fit
      z8_fit = z8
C
*     FUNCTION ctrl1
      ctrl1 = u1(t)
C
*     FUNCTION ctrl2
      ctrl2 = u2(t)
C
*     FUNCTION ctrl3
      ctrl3 = u3(t)
C
*     FUNCTION ctrl4
      ctrl4 = u4(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C






