C
C------------------------------------------------------
C
C     Problem:    NLSE
C
C     Date:       01.11.2001
C
C------------------------------------------------------
C
*     PARAMETER
      n = 18
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
C
C------------------------------------------------------
C
*     MACRO exact_r
      v = -4*zeta
      exact_r = 2*eta*cos(2*zeta*x + 4*(zeta**2-eta**2)*t - kappa)
     /               /cosh(2*eta*(x + 4*zeta*t - phi)) 
C
*     MACRO exact_i
      v = -4*zeta
      exact_i = 2*eta*sin(2*zeta*x + 4*(zeta**2-eta**2)*t - kappa)
     /               /cosh(2*eta*(x + 4*zeta*t - phi)) 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if availabl2323 e (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      eta, zeta, phi, kappa, ur, ui, ur_x, ui_x, ur_xx, ui_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION ur_t
      ur_t = -ui_xx + 2*(ur**2 + ui**2)*ui
C
*     FUNCTION ui_t
      ui_t =  ur_xx - 2*(ur**2 + ui**2)*ur
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION ur_0
      ur_0 = exact_r
C
*     FUNCTION ui_0
      ui_0 =  exact_i
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u_left
c      u_left = ...
C
c*     FUNCTION u_right
c      u_right = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
*     FUNCTION ur_x_left
      ur_x_left = 0
C
*     FUNCTION ui_x_left
      ui_x_left = 0
C
*     FUNCTION ur_x_right
      ur_x_right = 0
C
*     FUNCTION ui_x_right
      ui_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(i), i in ind
      fit(i) = ur
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


