C
C------------------------------------------------------
C
C     Problem:    NLP_P3
C
C     Date:       2.9.2007
C
C------------------------------------------------------
C    
*     PARAMETER
      L = 50  
C
C------------------------------------------------------
C    
*     SET OF INDICES
      IND = 1..L
C
C------------------------------------------------------
C      
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      X1, X2, X3
      T
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION F1
      F1 = SQRT(EXP(X1))              
C
*     FUNCTION F2
      F2 = SQRT(EXP(X2))              
C
*     FUNCTION F3
      F3 = SQRT(EXP(X3))
C
*     FUNCTION PLOT
      PLOT = X1 + X2*T + X3*T**2 - 1/(1 + T**2) 
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION G(I), I IN IND
      Y = (I-1)/(L-1)
      G(I) = X1 + X2*Y + X3*Y**2 - 1/(1 + Y**2)  
C
C------------------------------------------------------
C
*     END
C



