C
C------------------------------------------------------
C
C     Problem:    NLP_L5
C
C     Date:       02.07.2007
C
C------------------------------------------------------
C      
*     SET OF INDICES
      ind = 1..7
C
C------------------------------------------------------
C      
c*     INDEX
c      i
C
C------------------------------------------------------
C      
*     REAL CONSTANT
      pi = 3.1415926535      
C
C------------------------------------------------------
C      
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      x(k), k IN ind
      t
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y             
      w = 2*PI*DSIN(pi/180*(8.5 + 0.5*(t*162 + 1)))
      y = 1/15 + 2/15*SUM(COS(x(i)*w), i IN ind)
C
*     FUNCTION plot
      w = 2*PI*DSIN(pi/180*(8.5 + 0.5*(t*162 + 1)))
      plot = 1/15 + 2/15*SUM(COS(x(i)*w), i IN ind)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = -x(4) + x(6) - 1
C
*     FUNCTION g2
      g2 = x(7) - 3.5
C
*     FUNCTION g3
      g3 = -x(1) + x(2) - 0.4
C
*     FUNCTION g4
      g4 = -x(2) + x(3) - 0.4
C
*     FUNCTION g5
      g5 = -x(3) + x(4) - 0.4
C
*     FUNCTION g6
      g6 = -x(4) + x(5) - 0.4
C
*     FUNCTION g7
      g7 = -x(5) + x(6) - 0.4
C
*     FUNCTION g8
      g8 = -x(6) + x(7) - 0.4
C
C------------------------------------------------------
C
*     END
C
