C
C------------------------------------------------------
C
C     Problem:    NLIN_VI1
C
C     Date:       10.5.1999
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind_M = 1..10
      ind_M1 = 1..9
C
C------------------------------------------------------
C
*     REAL CONSTANT
      a = 1
      h2 = 1
C
C------------------------------------------------------
C
*     LININT eps
         0.0  0.0
       140.0  7.0
       260.0  1.0
       380.0  7.0
       500.0  1.0
       620.0  7.0
       740.0  1.0
       860.0  7.0
      1000.0  0.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      p1, p2, p3, p4, q1, q2, q3, q4
      Ge
      G(j), j in ind_M
      lambda(j), j in ind_M
      F(j), j in ind_M
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION F_p(j), j in ind_M
      F_p(j) = (h2*G(j)*eps(t) - F(j))/(lambda(j)*a)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION F0(j), j in ind_M
      if (t.lt.1) then
        F0(j) = 0
      else
        F0(j) = F(j)
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION sigma
      if (eps(t).gt.0) then
        e = eps(t)
      else
        e  =1.0E-10
      endif
      he = (p1/(p1 + e**2))**p2 + p3*e**p4
      h1 = (q1/(q1 + e**2))**q2 + q3*e**q4
      sigma = (Ge*he + h1*h2*sum(G(j), j in ind_M))*e
     /       - h1*sum(F(j), j in ind_M)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
c*     FUNCTION restr(j), j in ind_M1
c      restr(j) = lambda(j+1) - lambda(j)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




