C
C------------------------------------------------------
C
C     Problem:    NLINPDE
C
C     Date:       24.03.97
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      a, b, u, v, u_x, v_x, u_xx, v_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t
      u_t = (v - 1)*u_xx + v_x*u_x + (a*x*t - 2*t - a*(v - 1))*(u - 1)
     /       + 10*x*EXP(-b*x)
C
*     FUNCTION v_t
      v_t = v_xx + u_x + b*u - b + x**2 - 2*t - 10*t*EXP(-b*x)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = 1
C
*     FUNCTION v_0
      v_0 = 1
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION ul
      ul = 1
C
*     FUNCTION vl
      vl = 1
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
C
*     FUNCTION ur_x
      ur_x = 3 - 3*u
C
*     FUNCTION vr_x
      vr_x = 0.2*EXP(b)*(u - 1)
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit1
      fit1 = u 
C
*     FUNCTION fit1_err
      fit1_err = 1 + 10*x*t*EXP(-b*x) - u
C
*     FUNCTION fit2
      fit2 = v 
C
*     FUNCTION fit2_err
      fit2_err = 1 + x**2*t - v 
C
*     FUNCTION fit3
      fit3 = u 
C
*     FUNCTION fit3_err
      fit3_err = 1 + 10*x*t*EXP(-b*x) - u 
C
*     FUNCTION fit4
      fit4 = v 
C
*     FUNCTION fit4_err
      fit4_err = 1 + x**2*t - v 
C
*     FUNCTION fit5
      fit5 = u 

*     FUNCTION fit5_err
      fit5_err = 1 + 10*x*t*EXP(-b*x) - u 
C
*     FUNCTION fit6
      fit6 = v 

*     FUNCTION fit6_err
      fit6_err = 1 + x**2*t - v 
C
*     FUNCTION fit7
      fit7 = u 

*     FUNCTION fit7_err
      fit7_err = 1 + 10*x*t*EXP(-b*x) - u 
C
*     FUNCTION fit8
      fit8 = v 

*     FUNCTION fit8_err
      fit8_err = 1 + x**2*t - v 
C
*     FUNCTION fit9
      fit9 = u 

*     FUNCTION fit9_err
      fit9_err = 1 + 10*x*t*EXP(-b*x) - u 
C
*     FUNCTION fit10
      fit10 = v 

*     FUNCTION fit10_err
      fit10_err = 1 + x**2*t - v
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

