C
C------------------------------------------------------
C
C     Problem:    NL2_SORP
C
C     Date:       02.04.2003
C
C------------------------------------------------------
C
*     REAL CONSTANT
      vx = 0.1685
      D = 1.671
      ps = 1.216
      en = 0.495          
      C0 = 22.8                
      F = 0.8     
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (One
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.)
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Kd, N, alpha, C, S, C_x, S_x, C_xx, S_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION C_t       
      if (C.le.0) then
         w = 0
         wd = 0
      else
         w = C**N
         wd = N*C**N-1
      endif       
      St = alpha*((1 - F)*Kd*w - S)       
      C_t = (D*C_xx - vx*C_x - ps/en*St)/(1 + ps/en*F*Kd*wd) 
C
*     FUNCTION S_t
      S_t = St       
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION C_0  
      if (t.lt.1) then   
        C_0 = C0
      else
        C_0 = C
      endif    
C
*     FUNCTION S_0
      if (t.lt.1) then         
        S_0 = 0
      else
        S_0 = S
      endif    
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION C_left
      IF (t.LE.100) THEN
        C_left = C0
      ELSE  
        C_left = 0
      ENDIF  
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION C_x_right  
      C_x_right = -vx*(C0 - C)/D   
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      fit = S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
