C
C------------------------------------------------------
C
C     Problem:    NITRO
C
C     Date:       07.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      PTOT = 1.0         
      TEMP0= 450         
      F0   = 65.9      
      FA0  = 1.0           
      X0   = 0          
      HR   = -152100    
      D    = 3.0         
      VE   = 0.424      
      CP   = 6.62      
      R    = 82.06      
      PI   = 3.14159 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      U, KA, EAR, X, TEMP, TJ, Z
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      CA    = (1-X)*(FA0/F0)*PTOT/(R*TEMP)
      IF (CA .LE. 1E-10) THEN
        CA = 1E-10   
      ENDIF
      RA    = -KA*CA**0.578*EXP(-EAR/TEMP)
      X1 = - PI*D*D*VE/(4*FA0) * RA
      XP = X1
C
*     FUNCTION TEMPP
      TEMPP = (FA0*(-HR)*X1 - PI*D*U*(TEMP-TJ))/(F0*CP)   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      X_0 = X0
C
*     FUNCTION TEMP_0
      TEMP_0 = TEMP0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CA_fit
      CA_FIT = (1-X)*(FA0/F0)*PTOT/(R*TEMP)
C
*     FUNCTION TEMP_fit
      TEMP_fit = TEMP
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

