C
C------------------------------------------------------
C
C     Problem:    NITRIF
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      KS1=5.0
      KS2=3.0
      Y1=3.5
      Y2=1.1
      KLA=40
      CLS=8
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      VM1, VM2, K01, K02, S1, S2, S3, CL, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION S1P
      R1=VM1*(S1/(KS1+S1))*(CL/(K01+CL))  
      R2=VM2*(S2/(KS2+S2))*(CL/(K02+CL))  
      S1P=-R1 
C
*     FUNCTION S2P
      S2P=R1-R2   
C
*     FUNCTION S3P
      S3P=R2  
C
*     FUNCTION CLP
      CLP=-Y1*R1-Y2*R2+KLA*(CLS-CL)   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION S1_0
      S1_0=100
C
*     FUNCTION S2_0
      S2_0=0
C
*     FUNCTION S3_0
      S3_0=0
C
*     FUNCTION CL_0
      CL_0=8
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION S1_fit
      S1_fit=S1
C
*     FUNCTION S2_fit
      S2_fit=S2
C
*     FUNCTION S3_fit
      S3_fit=S3
C
*     FUNCTION CL_fit
      CL_fit=CL
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
