C
C------------------------------------------------------
C
C     Problem:    NET_3
C
C     Date:       12.5.1999
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..9
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
C
C------------------------------------------------------
C
*     MACRO u
      f = f1 + f2*t + f3*t**2 + f4*t**3 + f5*t**4 + f6*t**5
     /    + f7*t**6 + f8*t**7 + f9*t**8 + f10*t**9

C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      f1, f2, f3, f4, f5, f6, f7, f8, f9, f10
      u, v, u_x, v_x, u_xx, v_xx, w1, w2, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u1_t
      u1_t = u_xx
C
*     FUNCTION equ1
      equ1 = v - u_x
C
*     FUNCTION u2_t
      u2_t = u_xx
C
*     FUNCTION equ2
      equ2 = 0
C
*     FUNCTION u3_t
      u3_t = u_xx 
C
*     FUNCTION equ3
      equ3 = 0
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u1_0
      u1_0 = sin(0.5*pi*x)
C
*     FUNCTION v1_0
      v1_0 = 0.5*pi*cos(0.5*pi*x)
C
*     FUNCTION u2_0
      u2_0 = sin(0.5*pi*(1-(x-1)))
C
*     FUNCTION v2_0
      v2_0 = 0
C
*     FUNCTION u3_0
      u3_0 = sin(0.5*pi*(1-(x-2)))
C
*     FUNCTION v3_0
      v3_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION w1_t
      w1_t = u_xx
C
*     FUNCTION w2_t
      w2_t = v_xx
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION w1_0
      w1_0 = 1
C
*     FUNCTION w2_0
      w2_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION u1_right
      u1_right = u
C
*     FUNCTION u3_left
      u3_left = w1
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
*     FUNCTION u1_x_left
      u1_x_left = -f
C
*     FUNCTION u2_x_left
      u2_x_left = 0
C
*     FUNCTION u2_x_right
      u2_x_right = w2 - u_x
C
*     FUNCTION u3_x_right
      u3_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(i), i in ind
      fit(i) = u - 1
C
*     FUNCTION fit_f
      fit_f = f
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
