C
C------------------------------------------------------
C
C     Problem:    NDYN
C
C     Date:       19.09.1996
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      m1, m2, D, u, v, u_x, v_x, u_xx, v_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION up
      L = 1.72E-4*exp(5*t/(6*t + 1)) + 8E-4*exp(18*t/(13*t + 30)) 
      r = 4.5*exp(-1.387*t)
      up = (D*u_xx - 70*u_x - m1*L*u + 1.387*(r - v))/1.216
C
*     FUNCTION vp
      L = 1.72E-4*exp(5*t/(6*t + 1)) + 8E-4*exp(18*t/(13*t + 30))
      vp = (D*v_xx - 70*v_x - m2*L*v + 1.387*u)/3.8
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u0
      u0 = 1.0
C
*     FUNCTION v0
      v0 = 0.5
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
c*     FUNCTION ul
c      ul = ..
C
c*     FUNCTION vl
c      vl = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION ul_x
       ul_x = (15.79*u - 15.84)/D
C
*     FUNCTION vl_x
       vl_x = (15.79*v - 7.921)/D
C
*     FUNCTION ur_x
      ur_x = 0
C
*     FUNCTION vr_x
      vr_x = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION uFIT
      uFIT = u
C
*     FUNCTION vFIT
      vFIT = v
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
